const pwhash = require('password-hash');

exports.invoices = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('bills');
			datatable.rest(req, res);
			datatable.search('created_at', 'invoice', 'description', 'amount', 'status', 'id');
			datatable.params([
				['select', 'created_at', 'invoice', 'description', 'amount', 'status', 'id'],
				['where', 'user_id', '=', req.auth.user('id')]
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.requests = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('bills');
			datatable.rest(req, res);
			datatable.search('created_at', 'invoice', 'description', 'amount', 'status', 'id');
			datatable.params([
				['select', 'created_at', 'invoice', 'description', 'amount', 'status', 'id'],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.changestatus = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const status = $.helper('text').sanitize_alphanum(req.body.status);
				const password = req.body.password;
				const confirm = pwhash.verify(password, req.auth.user('password'));
				if(confirm) {
					const bill = await $.model('bills').findOne([
						['where', 'id', '=', id]
					]);

					if(bill) {
						const bank = await $.model('banks').findOne([
							['where', 'id', '=', bill.bank_id]
						]);

						const user = await $.model('users').findOne([
							['where', 'id', '=', bill.user_id]
						]);

						const db = $.config('database');
						const mailParams = {
							invoice: bill.invoice,
							email: user.email,
							name: user.name,
							username: user.username,
							bank_name: bank.name,
							rekening_nama: bill.bank_account,
							rekening_nomor: bill.bank_address,
							created_at: $.helper('text').datetimeidformat(bill.created_at),
							amount_request: $.helper('text').number_format(bill.amount_request),
							amount_additional: $.helper('text').number_format(bill.amount_additional),
							amount: $.helper('text').number_format(bill.amount)
						};
						await db.table.transaction(async function(trx){

							await $.model('bills').setTransaction(trx).update(id, {
								status: status,
								updated_by: req.auth.user('id')
							});

							if(status.toLowerCase() == 'paid') {
							
								switch(bill.type) {

									case 'Order':
											await $.model('devices').setTransaction(trx).update(bill.reference_id, {
												status: 'active',
												updated_by: req.auth.user('id')
											});

											await $.model('notifications').setTransaction(trx).insert({
												user_id: bill.user_id,
												type: 'General',
												message: `[${bill.invoice}] Pembayaran pembelian paket whatsapp telah berhasil diterima admin!`,
												is_show: '0',
												created_by: req.auth.user('id'),
											});

											$.service('mail').bill_success(Object.assign(mailParams, {
												status: "Paid",
												description: `#${bill.invoice} Tagihan pembelian paket whatsapp`
											}));
										break;

									case 'Renew':
											const {device} = JSON.parse(bill.params);
											await $.model('devices').setTransaction(trx).update(bill.reference_id, {
												status: device.status,
												status_sub: 'DISCONNECTED',
												expired_at: device.expired_at,
												update_by: req.auth.user('id')
											});

											await $.model('notifications').setTransaction(trx).insert({
												user_id: bill.user_id,
												type: 'General',
												message: `[${bill.invoice}] Pembayaran perpanjangan paket whatsapp telah berhasil diterima admin!`,
												is_show: '0',
												created_by: req.auth.user('id'),
											});

											$.service('mail').bill_success(Object.assign(mailParams, {
												status: "Paid",
												description: `#${bill.invoice} Tagihan perpanjangan paket whatsapp`
											}));
										break;

								}
							} else {

								switch(bill.type) {

									case 'Order':
											await $.model('devices').setTransaction(trx).update(bill.reference_id, {
												status: 'Unpaid',
												updated_by: req.auth.user('id')
											});
										break;

								}

								if(status.toLowerCase() == 'fail'){
									switch(bill.type) {

										case 'Order':
												await $.model('notifications').setTransaction(trx).insert({
													user_id: bill.user_id,
													type: 'General',
													message: `[${bill.invoice}] Pembayaran pembelian paket whatsapp tidak berhasil, silahkan hubungi admin!`,
													is_show: '0',
													created_by: req.auth.user('id'),
												});

												$.service('mail').bill_fail(Object.assign(mailParams, {
													status: "Fail",
													description: `#${bill.invoice} Tagihan pembelian paket whatsapp`
												}));
											break;

										case 'Renew':
												await $.model('notifications').setTransaction(trx).insert({
													user_id: bill.user_id,
													type: 'General',
													message: `[${bill.invoice}] Pembayaran perpanjangan paket whatsapp tidak berhasil, silahkan hubungi admin!`,
													is_show: '0',
													created_by: req.auth.user('id'),
												});

												$.service('mail').bill_fail(Object.assign(mailParams, {
													status: "Fail",
													description: `#${bill.invoice} Tagihan perpanjangan paket whatsapp`
												}));
											break;

									}
								} else {
									switch(bill.type) {

										case 'Order':
												await $.model('notifications').setTransaction(trx).insert({
													user_id: bill.user_id,
													type: 'General',
													message: `[${bill.invoice}] Pembayaran pembelian paket whatsapp sedang ditinjau admin!`,
													is_show: '0',
													created_by: req.auth.user('id'),
												});

												$.service('mail').bill_pending(Object.assign(mailParams, {
													status: "Pending",
													description: `#${bill.invoice} Tagihan pembelian paket whatsapp`
												}));
											break;

										case 'Renew':
												await $.model('notifications').setTransaction(trx).insert({
													user_id: bill.user_id,
													type: 'General',
													message: `[${bill.invoice}] Pembayaran perpanjangan paket whatsapp sedang ditinjau admin!`,
													is_show: '0',
													created_by: req.auth.user('id'),
												});

												$.service('mail').bill_pending(Object.assign(mailParams, {
													status: "Pending",
													description: `#${bill.invoice} Tagihan perpanjangan paket whatsapp`
												}));
											break;

									}
								}
							}

							await trx.commit();

						})
						return res.json({
							message: "Berhasil diperbarui!"
						});	
					} else {
						return res.status(500).json({message: 'tagihan tidak ditemukan!'});
					}
				} else {
					return res.status(500).json({message: 'kata sandi tidak sesuai!'});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}