const moment = require('moment');
const pwhash = require('password-hash');
const fs = require('fs');
const path = require('path');
const uniqid = require('uniqid');
const sharp = require('sharp');


exports.datatable = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('users');
			datatable.rest(req, res);
			datatable.search('created_at', 'name', 'username', 'status', 'id');
			datatable.params([
				['select', 'created_at', 'name', 'username', 'status', 'id'],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.register = ($) => {
	const __constructor = async function(req, res) {
		try {

			if(req.validate.isEmpty()) {

				const usernameCheck = await $.model('users').findOne([
					['where', 'username', req.body.username]
				]);

				if(usernameCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							username: 'Username sudah digunakan.',
						}
					});
				}

				const emailCheck = await $.model('users').findOne([
					['where', 'email', req.body.email]
				]);

				if(emailCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							email: 'Email sudah digunakan'
						}
					});
				}

				var pw = req.body.password;
				var pwc = req.body.password_confirm;
				var update_password = false;

				if (pw === pwc) {
					pw = pwhash.generate(pw);
					update_password = true;
				} else {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							password_confirm: 'Kata sandi tidak sesuai.'
						}
					});
				}

				var formdata = {
					name: req.body.name.replace(/[^0-9A-Za-z\s]/g, ''),
					username: req.body.username.toLowerCase().replace(/[^0-9a-z]/g, ''),
					email: req.body.email.toLowerCase().replace(/[^0-9a-z\@\.\_\-]/g, ''),
					phone: req.body.phone.replace(/[^0-9]/g, ""),
					api_key: uniqid(),
					photo: 'user.png'
				};


				if(typeof req.body.photo !== 'undefined') {
					const ext = path.extname(req.body.photo.path);

					if(!['.png', '.jpeg', '.jpg'].includes(ext)) {
						throw 'uploaded file not supported.'
					}

					const filename = `${uniqid()}.jpeg`;

					await sharp(req.body.photo.path)
					.resize(300, 300)
					.jpeg(75)
					.toFile(`./public/uploads/profiles/${filename}`)
					.then( data => { 
						formdata.photo = filename;
					})
					.catch( err => { 
						console.log(err);
					});
				}

				if(update_password) {
					formdata = Object.assign({}, formdata, {
						password: pw
					});
				}

				await $.model('users').insert(formdata);
				return res.json({
					message: "Berhasil mendaftarkan member baru!"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch (err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.update = ($) => {
	const __constructor = async function(req, res) {
		try {

			if(req.validate.isEmpty()) {

				const user_id = req.params ? req.params.id.replaceAll(/[^0-9]/gi) : '';
				const user = await $.model('users').findOne([
					['where', 'id', '=', user_id]
				]);

				if(!user) {
					throw 'Pengguna tidak ditemukan!'
				}

				const usernameCheck = await $.model('users').findOne([
					['where', 'username', req.body.username],
					['where', 'id', '!=', user_id]
				]);

				if(usernameCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							username: 'Username sudah digunakan.',
						}
					});
				}

				const emailCheck = await $.model('users').findOne([
					['where', 'email', req.body.email],
					['where', 'id', '!=', user_id]
				]);

				if(emailCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							email: 'Email sudah digunakan'
						}
					});
				}

				var pw = req.body.password;
				var pwc = req.body.password_confirm;
				var update_password = false;

				if(pw.length > 0 || pwc.length > 0) {

					if (pw === pwc) {
						pw = pwhash.generate(pw);
						update_password = true;
					} else {
						return res.status(400).json({
							message: "Periksa kembali form anda.",
							errors: {
								password_confirm: 'Kata sandi tidak sesuai.'
							}
						});
					}

				}


				var formdata = {
					name: req.body.name.replace(/[^0-9A-Za-z\s]/g, ''),
					status: req.body.status.replace(/[^0-9A-Za-z\s]/g, ''),
					username: req.body.username.toLowerCase().replace(/[^0-9a-z]/g, ''),
					email: req.body.email.toLowerCase().replace(/[^0-9a-z\@\.\_\-]/g, ''),
					phone: req.body.phone.replace(/[^0-9]/g, ""),
					created_by: req.auth.user('id')
				};


				if(typeof req.body.photo !== 'undefined') {
					const ext = path.extname(req.body.photo.path);

					if(!['.png', '.jpeg', '.jpg'].includes(ext)) {
						throw 'uploaded file not supported.'
					}

					const filename = `${uniqid()}.jpeg`;

					await sharp(req.body.photo.path)
					.resize(300, 300)
					.jpeg(75)
					.toFile(`./public/uploads/profiles/${filename}`)
					.then( data => { 
						formdata.photo = filename;
					})
					.catch( err => { 
						console.log(err);
					});
				}

				if(update_password) {
					formdata = Object.assign({}, formdata, {
						password: pw
					});
				}

				await $.model('users').update(user_id, formdata);
				return res.json({
					message: "Berhasil memperbarui biodata member!"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch (err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}