const devices = require('../../statics/devices.js');
const moment = require('moment');
const uniqid = require('uniqid');

exports.send_text = ($) => {

	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const code = $.helper('text').sanitize_alphanum(req.params.code);
				
				const __device = await $.model('devices').findOne([
					['where', 'session', '=', code]
				]);

				if(__device) {

					switch(__device.status.toLowerCase()) {
						case 'unpaid':
							return res.status(400).json({
								message: "Device unpaid.",
							});

						case 'inactive':
							return res.status(400).json({
								message: "Device inactive.",
							});
							break;
							
						case 'expired':
							return res.status(400).json({
								message: "Device expired.",
							});
							break;
					}

					if(moment().isAfter(__device.expired_at)) {
						return res.status(400).json({
							message: "Device expired!.",
						});
					}

					const instance = devices.get(code);

					if(instance) {
						const phone = $.helper('text').sanitize_int(req.body.phone);
						const message = req.body.message;
						const code = uniqid();
						const send_at = (typeof req.body.send_at !== 'undefined') ? req.body.send_at : moment().format("YYYY-MM-DD HH:mm:ss");
						const [msg_id] = await $.model('messages').insert({
							type: 'out',
							device_id: __device.id,
							code,
							phone: phone,
							message: message,
							send_at: send_at,
							media_type: 'text',
							media_url: '-',
							created_by: req.auth.user('id'),
							status: 'pending'
						});
						instance.send_message({
							id: msg_id,
							code,
							type: 'text',
							phone,
							message,
							send_at,
						});
						return res.json({
							message: "Pesan dalam proses!",
							msg_code: code
						});
					} else {
						return res.status(400).json({
							message: "Perangkat tidak dijalankan.",
						});
					}

				} else {
					return res.status(400).json({
						message: "Perangkat tidak ditemukan.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.send_image = ($) => {

	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const code = $.helper('text').sanitize_alphanum(req.params.code);
				
				const __device = await $.model('devices').findOne([
					['where', 'session', '=', code]
				]);

				if(__device) {

					switch(__device.status.toLowerCase()) {
						case 'unpaid':
							return res.status(400).json({
								message: "Device unpaid.",
							});

						case 'inactive':
							return res.status(400).json({
								message: "Device inactive.",
							});
							break;
							
						case 'expired':
							return res.status(400).json({
								message: "Device expired.",
							});
							break;
					}

					if(moment().isAfter(__device.expired_at)) {
						return res.status(400).json({
							message: "Device expired!.",
						});
					}
					
					const package = await $.model('packages').findOne([
						['where', 'id', '=', __device.package_id]
					]);
					const allowedFeatures = JSON.parse(package.params);
					if(allowedFeatures.indexOf("image") < 0) {
						return res.status(400).json({
							message: "Fitur tidak diijinkan pada paket anda.",
						});
					}

					const {instance} = devices.get(code);

					if(instance) {
						const phone = $.helper('text').sanitize_int(req.body.phone);
						const message = req.body.message;
						const url = req.body.url;
						const code = uniqid();
						const send_at = (typeof req.body.send_at !== 'undefined') ? req.body.send_at : moment().format("YYYY-MM-DD HH:mm:ss");
						const [msg_id] = await $.model('messages').insert({
							type: 'out',
							device_id: __device.id,
							phone: phone,
							code,
							message: message,
							send_at: send_at,
							media_type: 'image',
							media_url: url,
							created_by: req.auth.user('id'),
							status: 'pending'
						});
						instance.send_message({
							id: msg_id,
							type: 'image',
							code,
							url,
							phone,
							message,
							send_at,
						});
						return res.json({
							message: "Pesan dalam proses!",
							msg_code: code
						});
					} else {
						return res.status(400).json({
							message: "Perangkat tidak dijalankan.",
						});
					}

				} else {
					return res.status(400).json({
						message: "Perangkat tidak ditemukan.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.send_audio = ($) => {

	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const code = $.helper('text').sanitize_alphanum(req.params.code);
				
				const __device = await $.model('devices').findOne([
					['where', 'session', '=', code]
				]);

				if(__device) {

					switch(__device.status.toLowerCase()) {
						case 'unpaid':
							return res.status(400).json({
								message: "Device unpaid.",
							});

						case 'inactive':
							return res.status(400).json({
								message: "Device inactive.",
							});
							break;
							
						case 'expired':
							return res.status(400).json({
								message: "Device expired.",
							});
							break;
					}

					if(moment().isAfter(__device.expired_at)) {
						return res.status(400).json({
							message: "Device expired!.",
						});
					}
					
					const package = await $.model('packages').findOne([
						['where', 'id', '=', __device.package_id]
					]);
					const allowedFeatures = JSON.parse(package.params);
					if(allowedFeatures.indexOf("image") < 0) {
						return res.status(400).json({
							message: "Fitur tidak diijinkan pada paket anda.",
						});
					}

					const {instance} = devices.get(code);

					if(instance) {
						const phone = $.helper('text').sanitize_int(req.body.phone);
						const message = req.body.message;
						const url = req.body.url;
						const code = uniqid();
						const send_at = (typeof req.body.send_at !== 'undefined') ? req.body.send_at : moment().format("YYYY-MM-DD HH:mm:ss");
						const [msg_id] = await $.model('messages').insert({
							type: 'out',
							device_id: __device.id,
							code,
							phone: phone,
							message: message,
							send_at: send_at,
							media_type: 'audio',
							media_url: url,
							created_by: req.auth.user('id'),
							status: 'pending'
						});
						instance.send_message({
							id: msg_id,
							code,
							type: 'audio',
							url,
							phone,
							message,
							send_at,
						});
						return res.json({
							message: "Pesan dalam proses!",
							msg_code: code
						});
					} else {
						return res.status(400).json({
							message: "Perangkat tidak dijalankan.",
						});
					}

				} else {
					return res.status(400).json({
						message: "Perangkat tidak ditemukan.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.send_video = ($) => {

	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const code = $.helper('text').sanitize_alphanum(req.params.code);
				
				const __device = await $.model('devices').findOne([
					['where', 'session', '=', code]
				]);

				if(__device) {

					switch(__device.status.toLowerCase()) {
						case 'unpaid':
							return res.status(400).json({
								message: "Device unpaid.",
							});

						case 'inactive':
							return res.status(400).json({
								message: "Device inactive.",
							});
							break;
							
						case 'expired':
							return res.status(400).json({
								message: "Device expired.",
							});
							break;
					}

					if(moment().isAfter(__device.expired_at)) {
						return res.status(400).json({
							message: "Device expired!.",
						});
					}
					
					const package = await $.model('packages').findOne([
						['where', 'id', '=', __device.package_id]
					]);
					const allowedFeatures = JSON.parse(package.params);
					if(allowedFeatures.indexOf("image") < 0) {
						return res.status(400).json({
							message: "Fitur tidak diijinkan pada paket anda.",
						});
					}

					const {instance} = devices.get(code);

					if(instance) {
						const phone = $.helper('text').sanitize_int(req.body.phone);
						const message = req.body.message;
						const url = req.body.url;
						const code = uniqid();
						const send_at = (typeof req.body.send_at !== 'undefined') ? req.body.send_at : moment().format("YYYY-MM-DD HH:mm:ss");
						const [msg_id] = await $.model('messages').insert({
							type: 'out',
							device_id: __device.id,
							code,
							phone: phone,
							message: message,
							send_at: send_at,
							media_type: 'video',
							media_url: url,
							created_by: req.auth.user('id'),
							status: 'pending'
						});
						instance.send_message({
							id: msg_id,
							type: 'video',
							code,
							url,
							phone,
							message,
							send_at,
						});
						return res.json({
							message: "Pesan dalam proses!",
							msg_code: code
						});
					} else {
						return res.status(400).json({
							message: "Perangkat tidak dijalankan.",
						});
					}

				} else {
					return res.status(400).json({
						message: "Perangkat tidak ditemukan.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.send_document = ($) => {

	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const code = $.helper('text').sanitize_alphanum(req.params.code);
				
				const __device = await $.model('devices').findOne([
					['where', 'session', '=', code]
				]);

				if(__device) {

					switch(__device.status.toLowerCase()) {
						case 'unpaid':
							return res.status(400).json({
								message: "Device unpaid.",
							});

						case 'inactive':
							return res.status(400).json({
								message: "Device inactive.",
							});
							break;
							
						case 'expired':
							return res.status(400).json({
								message: "Device expired.",
							});
							break;
					}

					if(moment().isAfter(__device.expired_at)) {
						return res.status(400).json({
							message: "Device expired!.",
						});
					}
					
					const package = await $.model('packages').findOne([
						['where', 'id', '=', __device.package_id]
					]);
					const allowedFeatures = JSON.parse(package.params);
					if(allowedFeatures.indexOf("image") < 0) {
						return res.status(400).json({
							message: "Fitur tidak diijinkan pada paket anda.",
						});
					}

					const {instance} = devices.get(code);

					if(instance) {
						const phone = $.helper('text').sanitize_int(req.body.phone);
						const message = req.body.message;
						const url = req.body.url;
						const code = uniqid();
						const send_at = (typeof req.body.send_at !== 'undefined') ? req.body.send_at : moment().format("YYYY-MM-DD HH:mm:ss");
						const [msg_id] = await $.model('messages').insert({
							type: 'out',
							device_id: __device.id,
							code,
							phone: phone,
							message: message,
							send_at: send_at,
							media_type: 'document',
							media_url: url,
							created_by: req.auth.user('id'),
							status: 'pending'
						});
						instance.send_message({
							id: msg_id,
							type: 'document',
							code,
							url,
							phone,
							message,
							send_at,
						});
						return res.json({
							message: "Pesan dalam proses!",
							msg_code: code
						});
					} else {
						return res.status(400).json({
							message: "Perangkat tidak dijalankan.",
						});
					}

				} else {
					return res.status(400).json({
						message: "Perangkat tidak ditemukan.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}