exports.create = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("whatsapp/create");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.write = ($) => {
	const __constructor = async function(req, res) {
		try {
			const devices = await $.model('devices').findAll([
				['where', 'status', '=', 'active'],
				['where', 'user_id', '=', req.auth.user('id')]
			]);
			return res.renderMemberArea("whatsapp/write", {devices});
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.order = ($) => {
	const __constructor = async function(req, res) {
		try {
			const slug = req.params.slug.toLowerCase().replaceAll(/[^0-9a-z]/gi, '');
			const banks = await $.model('banks').findAll([
				['where', 'status', '=', 'Show']
			]);
			const package = await $.model('packages').findOne([
				['where', 'status', '=', 'show'],
				['where', 'slug', '=', slug]
			]);

			if(package) {
				if(slug == 'trial') {
					return res.renderMemberArea("whatsapp/trial", {
						banks: banks,
						package: package
					});
				} else {
					return res.renderMemberArea("whatsapp/order", {
						banks: banks,
						package: package
					});
				}
			} else {
				return res.status(404).json({
					message: 'Page not found!'
				});
			}
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.packages = ($) => {
	const __constructor = async function(req, res) {
		try {
			const packages = await $.model('packages').findAll([
				['where', 'status', '=', 'show']
			]);
			return res.renderMemberArea("whatsapp/packages", {
				packages: packages
			});
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.devices = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("whatsapp/devices");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.detail = ($) => {
	const __constructor = async function(req, res) {
		try {
			const id = $.helper('text').sanitize_int(req.params.id);
			const device = await $.model('devices').findOne([
				['where', 'id', '=', id]
			]);

			if(device) {
				const package = await $.model('packages').findOne([
					['where', 'id', '=', device.package_id]
				]);

				let changestatus = true;

				if(
					device.status.toLowerCase() == 'unpaid' ||
					device.status.toLowerCase() == 'expired'
				) {
					changestatus = false;
				}
				return res.renderMemberArea("whatsapp/detail", {
					device: device,
					package: package,
					changestatus: changestatus,
				});
			} else {
				return res.status(404).json({
					message: 'Page not found!'
				});
			}
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.inbox = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("whatsapp/inbox");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.outbox = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("whatsapp/outbox");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.webhooks = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("whatsapp/webhooks");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.autoreplies = ($) => {
	const __constructor = async function(req, res) {
		try {
			const devices = await $.model('devices').findAll([
				['where', 'status', '=', 'active'],
				['where', 'user_id', req.auth.user('id')]
			]);
			return res.renderMemberArea("whatsapp/autoreplies", {devices});
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.renew = ($) => {
	const __constructor = async function(req, res) {
		try {
			const id = req.params.id.toLowerCase().replaceAll(/[^0-9]/gi, '');
			const banks = await $.model('banks').findAll([
				['where', 'status', '=', 'Show']
			]);
			const device = await $.model('devices').findOne([
				['where', 'id', '=', id]
			]);

			if(device) {
				const package = await $.model('packages').findOne([
					['where', 'status', '=', 'show'],
					['where', 'slug', '!=', 'trial'],
					['where', 'id', '=', device.package_id]
				]);

				if(package) {
					return res.renderMemberArea("whatsapp/renew", {
						device: device,
						banks: banks,
						package: package
					});
				} else {
					return res.status(404).json({
						message: 'Page not found!'
					});
				}
			} else {
				return res.status(404).json({
					message: 'Page not found!'
				});
			}
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}