const __base_filters = require("./base_filters");

module.exports = (...params) => {
	const [$, param] = params;
	const base_filters = new __base_filters();
	
	const __constructor = async function (req, res, next) {
		try {
			const userdata = req.auth.get_userdata();
			if(userdata) {
				next();
			} else {
				if(req.xhr || req.originalUrl.indexOf('api/')) {
					return res.status(401).json({
						"message": "unauthorized"
					});
				} else {
					return res.status(401).redirect( $.base_url('auth/login') );
				}
			}
		} catch(err) {
			if(req.xhr) {
				return res.status(401).json({
					"message": "unauthorized"
				});
			} else {
				return res.status(401).redirect( $.base_url('auth/login') );
			}
		}
	}

	return __constructor;
}