const moment = require('moment');

exports.toTitleCase = function(str) {
  return str.toLowerCase().split(' ').map(function (word) {
    return (word.charAt(0).toUpperCase() + word.slice(1));
  }).join(' ');
}

exports.sanitize_int = function(value) {
	return value.toString().replace(/[^0-9]/g, "");
}

exports.random_number = function(min, max) {
    return Math.random() * (max - min) + min;
}

exports.sanitize_alphanum = function(value) {
	return value.toString().toLowerCase().replace(/[^0-9a-z]/g, "");
}

exports.sanitize_email = function(value) {
	return value.toString().toLowerCase().replace(/[^0-9a-z\@\.\_\-]/g, "");
}

exports.datetimeidformat = function(date){
   return moment(date).format("DD/MM/YYYY HH:mm:ss");
};

exports.dateidformat = function(date){
   return moment(date).format("DD/MM/YYYY");
};

exports.get_datetime = function(format="DD/MM/YYYY HH:mm:ss") {
	return moment().format(format);
}

exports.get_date = function(format="DD/MM/YYYY") {
	return moment().format(format);
}

exports.number_format = function(value="0") {
	return Intl.NumberFormat().format(parseInt(value)).replace(",", ".");
}

exports.randomString = function() {
	const salt = (parseInt(Math.random().toString().substr(2))).toString(36);
	const combine = salt.concat((Date.now() + parseInt(Math.random().toString().substr(2))).toString(36));
	return combine;
}

exports.replaceAll = function(str,mapObj){
    var re = new RegExp(Object.keys(mapObj).join("|"),"gi");

    return str.replace(re, function(matched){
        return mapObj[matched.toLowerCase()];
    });
}

exports.replaceHTML = function(str,mapObj){
	 let map = Object.keys(mapObj).map(function(data){
	 	return `\{\{${data}\}\}`;
	 });

    var re = new RegExp(map.join("|"),"gi");
    return str.replace(re, function(matched){
    	return mapObj[matched.toLowerCase().replaceAll(/[^0-9a-z\_]/gi, '')];
    });
}

exports.isValidUrl = function(urlString) {
  	var urlPattern = new RegExp('^(https?:\\/\\/)?'+ // validate protocol
    '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // validate domain name
    '((\\d{1,3}\\.){3}\\d{1,3}))'+ // validate OR ip (v4) address
    '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // validate port and path
    '(\\?[;&a-z\\d%_.~+=-]*)?'+ // validate query string
    '(\\#[-a-z\\d_]*)?$','i'); // validate fragment locator
  return !!urlPattern.test(urlString);
}