const {
default: makeWASocket,
	Browsers,
	MessageType,
	MessageOptions,
	Mimetype,
	downloadMediaMessage,
	DisconnectReason,
	BufferJSON,
	AnyMessageContent,
	delay,
	fetchLatestBaileysVersion,
	isJidBroadcast,
	makeCacheableSignalKeyStore,
	makeInMemoryStore,
	MessageRetryMap,
	useMultiFileAuthState,
	msgRetryCounterMap
} = require("@whiskeysockets/baileys");
const { Sticker, createSticker, StickerTypes } = require('wa-sticker-formatter');
const log = (pino = require("pino"));
const { Boom } = require("@hapi/boom");
const path = require('path');
const fs = require('fs');
const mime = require('mime');
const moment = require('moment');
const zevents = require('./zevents.js');

const uniqid = function uniqid(prefix = "", random = false) {
	const sec = Date.now() * 1000 + Math.random() * 1000;
	const id = sec.toString(16).replace(/\./g, "").padEnd(14, "0");
	return `${prefix}${id}${random ? `.${Math.trunc(Math.random() * 100000000)}`:""}`;
};

module.exports = (function(configs={}) {
	//private variables
	let callbacks = new zevents();
	let store = makeInMemoryStore({ logger: pino().child({ level: "silent", stream: "store" }) });
	let sock;
	let isNotInitialized = true;
	let messages = new Map();
	let session = typeof configs.session == 'string' ? configs.session : uniqid();
	let autoreplies = new Array();
	let serviceStop = false;


	const write_log = function(msg) {
		let info = typeof msg == 'string' ? msg : '';
		if(typeof msg == 'object') info = JSON.stringify(msg);
		console.log(`|- ${moment().format('DD/MM/YYYY HH:mm:ss')} -|`);
		console.log(`${session}: ${info}`);
		console.log(`|-----------------------|`);
	}

	const deleteAllFilesInDir = function(dirPath) {
		try {
			fs.readdirSync(dirPath).forEach(file => {
				fs.unlinkSync(path.join(dirPath, file));
			});
		} catch (error) {
			write_log(error);
		}
	}

	const phone_number_format = function(phone_number) {
		phone_number = phone_number.replaceAll(/[^0-9]/gi, '');
		const front_phone_number = phone_number.substr(0,2);
		if(front_phone_number=='08') {
			phone_number = `62${phone_number.substring(1)}`;
		}
		const phone_address = `${phone_number}@s.whatsapp.net`;
		return phone_address;
	}

	const queueMessages = function() {
		setInterval(function(){
			messages.forEach(function(params, key){
				try {
					if(moment().isAfter(params.send_at)) {
						if(typeof params.status == 'undefined') {
							params.status = 'pending';
							write_log(`sending new ${params.type} message`);
							switch(params.type.toLowerCase()) {
							case 'text':
								send_text(params).then(function(__params){
									params.status = 'sent';

									callbacks.emit('send_message', params);

									write_log(`sent ${params.phone} message`);
								}).catch(function(e){
									params.status = 'fail';
									console.log(e);
									let re = typeof e == 'string' ? e : '';
									if(typeof e == 'object') re = JSON.stringify(new Boom(e).output);
									messages.delete(key);
									write_log(e);

									callbacks.emit('send_message', params);

									write_log(`fail ${params.phone} message`);
								});
								break;
							case 'image':
								send_image(params).then(function(__params){
									params.status = 'sent';

									callbacks.emit('send_message', params);

									write_log(`sent ${params.phone} message`);
								}).catch(function(e){
									params.status = 'fail';
									let re = typeof e == 'string' ? e : '';
									if(typeof e == 'object') re = JSON.stringify(new Boom(e).output);
									messages.delete(key);
									write_log(e);

									callbacks.emit('send_message', params);

									write_log(`fail ${params.phone} message`);
								});
								break;
							case 'audio':
								send_audio(params).then(function(__params){
									params.status = 'sent';

									callbacks.emit('send_message', params);

									write_log(`sent ${params.phone} message`);
								}).catch(function(e){
									params.status = 'fail';
									let re = typeof e == 'string' ? e : '';
									if(typeof e == 'object') re = JSON.stringify(new Boom(e).output);
									messages.delete(key);
									write_log(e);

									callbacks.emit('send_message', params);

									write_log(`fail ${params.phone} message`);
								});
								break;
							case 'video':
								send_video(params).then(function(__params){
									params.status = 'sent';

									callbacks.emit('send_message', params);

									write_log(`sent ${params.phone} message`);
								}).catch(function(e){
									params.status = 'fail';
									let re = typeof e == 'string' ? e : '';
									if(typeof e == 'object') re = JSON.stringify(new Boom(e).output);es.delete(key);
									write_log(e);

									callbacks.emit('send_message', params);

									write_log(`fail ${params.phone} message`);
								});
								break;
							case 'document':
								send_document(params).then(function(__params){
									params.status = 'sent';

									callbacks.emit('send_message', params);

									write_log(`sent ${params.phone} message`);
								}).catch(function(e){
									params.status = 'fail';
									let re = typeof e == 'string' ? e : '';
									if(typeof e == 'object') re = JSON.stringify(new Boom(e).output);
									messages.delete(key);
									write_log(e);

									callbacks.emit('send_message', params);

									write_log(`fail ${params.phone} message`);
								});
								break;
							}
						} else {
							if(params.status == 'sent') {
								messages.delete(key);
							}
						}
					}
				} catch(err) {
					write_log(err);
				}
			});
		}, 250);
	}

	const connect = async function() {
		try {
			const session_path = path.join(process.cwd(), `sessions`, session);
			const { state, saveCreds } = await useMultiFileAuthState(session_path);
			let { version, isLatest } = await fetchLatestBaileysVersion();
			
			//emit event
			callbacks.emit('connecting');

			write_log('connecting to server');
			
			sock = makeWASocket({
				printQRInTerminal: false,
				auth: state,
				logger: log({ level: "silent" }),
				version: [2,2323,4],
				shouldIgnoreJid: jid => isJidBroadcast(jid),
				browser: Browsers.macOS("Desktop"),
			});

			store.bind(sock.ev);
			sock.ev.on('connection.update', async (update) => {
				const { connection, lastDisconnect } = update;
				if (connection === 'close') {
					//emit event
					callbacks.emit('disconnected');

					if (update.lastDisconnect.error.output.statusCode === 401) {
						//clear session
						deleteAllFilesInDir(session_path);
					}

					if(serviceStop) {
						callbacks.emit('stop');
					} else {
						connect();
					}
				} 

				if (connection === 'open') {
					write_log('opened connection');

					//emit event
					callbacks.emit('connected');

					if(isNotInitialized) {
						isNotInitialized = false;
						queueMessages();
					}
				}

				if (update.qr) {
					qr = update.qr;
					write_log('update QR');

					//emit event
					callbacks.emit('qr', qr);
				}
			});
			sock.ev.on("creds.update", saveCreds);
			sock.ev.on("messages.upsert", async ({ messages, type }) => {
				if (type === "notify" && typeof messages[0]?.message?.conversation !== 'undefined') {
					const [message] = messages;
					if (!message.key.fromMe) {
						const msg = message.message.conversation;
						const phoneId = message.key.remoteJid;
						callbacks.emit('receive_message', message);
						write_log(`receive new message`);

						autoreplies.forEach((val, key) => {
							try {
								if(val.is_regex=="Yes") {
									if(msg.match(new RegExp(val.message, "gi"))) {
										write_log(`send auto reply: ${val.reply}`)
										sock.sendMessage(phoneId, {text: val.reply});
										return;
									}
								} else {
									if(msg == val.message) {
										write_log(`send auto reply: ${val.reply}`)
										sock.sendMessage(phoneId, {text: val.reply});
										return;
									}
								}
							} catch(err) {
								console.log(err);
							}
						});

						switch(msg.toLowerCase()) {
							case '/status':
									sock.sendMessage(phoneId, {text: "ok!"}, {quoted: message});
								break;
							case '/ping':
									sock.sendMessage(phoneId, {text: "pong!"}, {quoted: message});
								break;
							case '/now':
									sock.sendMessage(phoneId, {text: moment().format("DD/MM/YYYY HH:mm:ss")}, {quoted: message});
								break;
						}
					}
					
					if(typeof message.message.imageMessage !== 'undefined') {
						
						write_log('image message received.');

						if(message.message.imageMessage?.caption == '!sticker') {
							write_log('sticker command receive.');
							write_log('downloading media.');

							const buffer = await downloadMediaMessage(
								message,
								'buffer',
								{ },
								{
									logger: pino({ level: "silent" }),
									reuploadRequest: sock.updateMediaMessage
								}
							);

							write_log('create sticker from buffer.');
							const sticker = new Sticker(buffer, {
							    pack: 'Sticker',
							    author: 'Me',
							})

							write_log('sending back generated sticker.');
			                sock.sendMessage(message.key.remoteJid, await sticker.toMessage(), {quoted: message});
						}
					}
				}
			});
		} catch(err) {
			connect();
			write_log(err);
		}
	}

	const isConnected = function() {
		return sock && typeof sock.user !== 'undefined' ? true : false;
	};

	const send_text = function(__params) {
		return new Promise(async (resolve, err) => {
			const {phone, message} = __params;
			try {
				if(isConnected()) {
					const params = new Array();
					const exists = await sock.onWhatsApp(phone);
					const phoneId = exists?.jid || (exists && exists[0]?.jid);
					params.push(phoneId);
					params.push({ text: message });
					if (phoneId) {
						await sock.sendMessage(...params);
						resolve(__params);
						write_log('message sended!');
					} else {
						throw 'phone number not registered.';
					}
				} else {
					throw 'device not connected.';
				}
			} catch(e) {
				err(e)
			}
		});
	}

	const send_audio = function(__params) {
		return new Promise(async (resolve, err) => {
			const {phone, url, message} = __params;
			try {
				if(isConnected()) {
					const exists = await sock.onWhatsApp(phone);
					const phoneId = exists?.jid || (exists && exists[0]?.jid);
					const params = new Array();
					params.push(phoneId);
					params.push({
						audio: {
							url: url,
						}, 
						mimetype: 'audio/mp4',
						url: url,
						caption: message,
					});
					if (phoneId) {
						await sock.sendMessage(...params);
						resolve(__params);
						write_log('message sended!');
					} else {
						throw 'phone number not registered.';
					}
				} else {
					throw 'device not connected.';
				}
			} catch(e) {
				err(e)
			}
		});
	}

	const send_image = function(__params) {
		return new Promise(async (resolve, err) => {
			const {phone, url, message} = __params;
			try {
				if(isConnected()) {
					const exists = await sock.onWhatsApp(phone);
					const phoneId = exists?.jid || (exists && exists[0]?.jid);
					const params = new Array();
					params.push(phoneId);
					params.push({
						image: {
							url
						},
						caption: message
					});
					if (phoneId) {
						await sock.sendMessage(...params);
						resolve(__params);
						write_log('message sended!');
					} else {
						throw 'phone number not registered.';
					}
				} else {
					throw 'device not connected.';
				}
			} catch(e) {
				err(e)
			}
		});
	}

	const send_video = function(__params) {
		return new Promise(async (resolve, err) => {
			const {phone, url, message} = __params;
			try {
				if(isConnected()) {
					const exists = await sock.onWhatsApp(phone);
					const phoneId = exists?.jid || (exists && exists[0]?.jid);
					const params = new Array();
					params.push(phoneId);
					params.push({
						video: {
							url: url,
							gifPlayback: false
						},
						caption: message,
					});
					if (phoneId) {
						await sock.sendMessage(...params);
						resolve(__params);
						write_log('message sended!');
					} else {
						throw 'phone number not registered.';
					}
				} else {
					throw 'device not connected.';
				}
			} catch(e) {
				err(e)
			}
		});
	}

	const send_document = function(__params) {
		return new Promise(async (resolve, err) => {
			const {phone, url, message} = __params;
			try {
				if(isConnected()) {
					const exists = await sock.onWhatsApp(phone);
					const phoneId = exists?.jid || (exists && exists[0]?.jid);
					const mime_type = mime.getType(path.extname(url));
					const file_name = path.basename(url);
					const params = new Array();
					params.push(phoneId);
					params.push({
						document: {
							url: url,
						},
						caption: message,
						mimetype: mime_type,
						fileName: file_name
					});
					if (phoneId) {
						await sock.sendMessage(...params);
						resolve(__params);
						write_log('message sended!');
					} else {
						throw 'phone number not registered.';
					}
				} else {
					throw 'device not connected.';
				}
			} catch(e) {
				err(e)
			}
		});
	}

	this.send_message = function(msg) {
		write_log(`created new ${msg.type} message`);
		msg.phone = phone_number_format(msg.phone);
		messages.set( uniqid(), msg );
	}

	this.restart = function() {
		try {
			sock.end({
				output: {
					message: 'device restart',
					statusCode: 400
				}
			});
			write_log('restart device');
		} catch(err) {
			write_log(err);
		}
	}

	this.logout = function() {
		sock.logout().then(function(){
			write_log('device logouted');
		}).catch(function(err){
			write_log(err);
		});
	}

	this.stop = function() {
		try {
			serviceStop = true;
			sock.end({
				output: {
					message: 'device stop',
					statusCode: 400
				}
			});
			write_log('stop device');
		} catch(err) {
			write_log(err);
		}
	}

	this.events = callbacks;
	this.isConnected = isConnected;
	this.setAutoReplies = function(data) {
		autoreplies = data;
		return this;
	}
	connect();
});