module.exports = function(routes){

	routes.group("/", routes.filter('init'), routes => {
		routes.get("/", routes.controller("web/landing_page/home:index"));
		routes.get("/home", routes.controller("web/landing_page/home:index"));
		routes.get("/blogs", routes.controller("web/landing_page/blogs:index"));
	});

	routes.group("/auth", function(routes) {
		routes.get("/login", routes.controller("web/auth:login"));
		routes.get("/register", routes.controller("web/auth:register"));
		routes.get("/forgot", routes.controller("web/auth:forgot"));
		routes.get("/forgot/:token", routes.controller("web/auth:new_password"));
		routes.get("/logout", routes.controller("web/auth:logout"));
	});

	routes.group("/member_area", routes.filter("auth"), routes => {
		routes.get("/", routes.controller("web/member_area/dashboard:index"));
		routes.get("/notifications", routes.controller("web/member_area/notifications:index"));
		routes.get("/dashboard", routes.controller("web/member_area/dashboard:index"));
		routes.get("/profile", routes.controller("web/member_area/profile:index"));
		routes.get("/paymentmethods", routes.controller("web/member_area/paymentmethods:index"));

		routes.group("/bills", routes => {
			routes.get("/invoices", routes.controller("web/member_area/bills:invoices"));
			routes.get("/invoice/:code", routes.controller("web/member_area/bills:invoice"));
			routes.get("/request", routes.filter('ingroup:admin'), routes.controller("web/member_area/bills:request"));
		});

		routes.group("/whatsapp", routes => {
			routes.get("/package/:slug/order", routes.controller("web/member_area/whatsapp:order"));
			routes.get("/packages", routes.controller("web/member_area/whatsapp:packages"));
			routes.get("/create", routes.controller("web/member_area/whatsapp:create"));
			routes.get("/devices", routes.controller("web/member_area/whatsapp:devices"));
			routes.get("/:id/detail", routes.controller("web/member_area/whatsapp:detail"));
			routes.get("/:id/renew", routes.controller("web/member_area/whatsapp:renew"));
			routes.get("/inbox", routes.controller("web/member_area/whatsapp:inbox"));
			routes.get("/outbox", routes.controller("web/member_area/whatsapp:outbox"));
			routes.get("/webhooks", routes.controller("web/member_area/whatsapp:webhooks"));
			routes.get("/autoreplies", routes.controller("web/member_area/whatsapp:autoreplies"));
			routes.get("/write", routes.controller("web/member_area/whatsapp:write"));
		});

		routes.group("/users", routes.filter('ingroup:admin'), routes => {
			routes.get("/", routes.controller("web/member_area/users:index"));
			routes.get("/:id/update", routes.controller("web/member_area/users:update"));
			routes.get("/register", routes.controller("web/member_area/users:register"));
		});
	});

}