const cron = require('node-cron');
const moment = require('moment');
const deviceModel = require('../models/devices.js');
const devices = require('./devices.js');

function write_log(msg) {
	console.log(`|- ${moment().format('DD/MM/YYYY HH:mm:ss')} -|`);
	console.log(msg);
	console.log(`|-----------------------|`);
}

module.exports = function() {
	const __m = new deviceModel();
	write_log('Cronjob intialized.');
	cron.schedule(`* 1 * * *`, async function() {
		write_log('Expired device checked.');

		__m.batchUpdate([
			['where', 'status', '!=', 'expired'],
			['whereRaw', 'expired_at <= NOW()']
		],{
			status: 'expired',
			status_sub: 'Disconnected'
		});

		const list = await __m.findAll([
			['where', 'status', '!=', 'expired'],
			['whereRaw', 'expired_at <= NOW()']
		]);

		list.forEach(function(val, key){
			try {
				const instance = devices.get(val.session);
				if(instance) {
					instance.stop();
				}
			} catch(err) {
				console.log(err);
			}
		});
	});
}