exports.login = function($) {
	return [
		$.body('username').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'username') ),
		$.body('password').notEmpty().isLength({ min: 8 }).withMessage($.lang('validations', 'isLength', '8')),
	];
}

exports.forgot = function($) {
	return [
		$.body('email').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'email') ),
	];
}

exports.new_password = function($) {
	return [
		$.body('password').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'kata sandi') ),
		$.body('password_confirm').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'konfirmasi kata sandi') ),
		$.body('token').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'token') ),
	];
}

exports.register = function($) {
	return [
		$.body('name').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'nama') ),
		$.body('username').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'username') ),
		$.body('email').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'email') ),
		$.body('phone').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'telepon') ),
		$.body('password').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'kata sandi') ),
		$.body('password_confirm').notEmpty().withMessage( $.lang('validations', 'notEmpty', 'konfirmasi kata sandi') ),
	];
}