const system = require('../system.js');
const $ = new system();

exports.base_url = function(...params){
    const options = params.slice(-1);
    params.pop();
    return $.base_url(params.join('/'));
};
exports.get_date = $.helper('text').get_date;
exports.datetimeidformat = $.helper('text').datetimeidformat;
exports.dateidformat = $.helper('text').dateidformat;
exports.number_format = $.helper('text').number_format;
exports.toTitleCase = function(str, options) {
    if(typeof str.fn == 'function') {
        return $.helper('text').toTitleCase(str.fn(this));
    } else {
        return $.helper('text').toTitleCase(str);
    }
};
const moment = require('moment');
exports.strtolower = function(name, options) {
    return name.toString().toLowerCase();
}

exports.config_app = function(value, options) {
    const conf = $.config('app');
    return conf[value];
}

exports.section = function(name, options) {
    var helper = this;
     if (!this._sections) {
        this._sections = {};
        this._sections._get = function(arg){
           if(typeof helper._sections[arg] === 'undefined'){
              // throw new Error('The section "' + arg + '" is required.')
              return '';
           } else {
              return helper._sections[arg];
           }
        }
     }

     if(!this._sections[name]){
        this._sections[name] = options.fn(this);
     }

     return null;
}

exports.render_section = function(name) {
    try {
        return this._sections._get(name);
    } catch (err) {
        return '';
    }
}

exports.isdefined = function(value) {
   return value !== undefined;
}

exports.jsoneach = function(context, options) {
  var ret = "";
  try {
     var content = JSON.parse(context);
     for (var i = 0, j = content.length; i < j; i++) {
       ret = ret + options.fn(content[i]);
     }
  } catch(err) {
   
  }
  return ret;
}

exports.ifcond = function (v1, operator, v2, options) {
    switch (operator) {
        case '==':
            return (v1 == v2) ? options.fn(this) : options.inverse(this);
        case '===':
            return (v1 === v2) ? options.fn(this) : options.inverse(this);
        case '!=':
            return (v1 != v2) ? options.fn(this) : options.inverse(this);
        case '!==':
            return (v1 !== v2) ? options.fn(this) : options.inverse(this);
        case '<':
            return (v1 < v2) ? options.fn(this) : options.inverse(this);
        case '<=':
            return (v1 <= v2) ? options.fn(this) : options.inverse(this);
        case '>':
            return (v1 > v2) ? options.fn(this) : options.inverse(this);
        case '>=':
            return (v1 >= v2) ? options.fn(this) : options.inverse(this);
        case '&&':
            return (v1 && v2) ? options.fn(this) : options.inverse(this);
        case '||':
            return (v1 || v2) ? options.fn(this) : options.inverse(this);
        default:
            return options.inverse(this);
    }
    
}

exports.print_cond = function(v1, v2, v3, options) {
    if(v1 == v2) {
        return v3;
    }
}